local c;
local player = Var "Player";
local ShowComboAt = THEME:GetMetric("Combo", "ShowComboAt");
local Pulse = THEME:GetMetric("Combo", "PulseCommand");
local PulseLabel = THEME:GetMetric("Combo", "PulseLabelCommand");

local NumberMinZoom =1.4
local NumberMaxZoom =2
local NumberMaxZoomAt =300

local LabelMinZoom = 1
local LabelMaxZoom =1.5

local t = Def.ActorFrame {
	InitCommand=cmd(vertalign,bottom);
	LoadFont( "Combo", "numbers" ) .. {
		Name="Number";
		OnCommand =cmd(y,22;shadowlength,4;zoomy,1;zoomx,1.2;diffusebottomedge,color("0.75,0.75,0.75,1");halign,1;valign,1;strokecolor,color("0.9,0.9,0.9,1");skewx,-0.1;);
		ComboCommand=function(self, param)
			local iCombo = param.Misses or param.Combo;
			if not iCombo or iCombo < ShowComboAt then
				self:visible(false);
				return;
			end

			param.Zoom = scale( iCombo, 0, NumberMaxZoomAt, NumberMinZoom, NumberMaxZoom );
			param.Zoom = clamp( param.Zoom, NumberMinZoom, NumberMaxZoom );
		
			self:visible(true);
			self:settext( string.format("%i", iCombo) );
			
			if param.FullComboW1 then
				self:diffusebottomedge(color("#00fffc"));
				self:glowshift();
			elseif param.FullComboW2 then
				self:diffusebottomedge(color("#fff266"));
				self:glowshift();
			elseif param.FullComboW3 then
				self:diffusebottomedge(color("#00ff0c"));
				self:stopeffect();
			elseif param.Combo then
				self:diffusebottomedge(color("0,0.75,0.75,1"));
				self:stopeffect();
			else
				self:diffusebottomedge(color("#ff0000"));	
				self:stopeffect();
			end
 			self:stoptweening(); 
			self:zoomy(0);
			self:linear(0.05);
			self:zoomy(param.Zoom);
			self:zoomx(param.Zoom*1.2);
		end;
	};
	LoadFont("Common Normal") .. {
		Name="Label";
		OnCommand =cmd(x,6;y,22;shadowlength,4;zoomy,1;zoomx,1.2;diffusebottomedge,color("0,0.75,0.75,1");halign,0;valign,1;strokecolor,color("0.6,0.6,0.6,1");skewx,-0.1;);
		ComboCommand=function(self, param)
			local iCombo = param.Misses or param.Combo;
			if not iCombo or iCombo < ShowComboAt then
				self:visible(false);
				return;
			end

			local labeltext = "";
			if param.Combo then
				labeltext = "COMBO";
			else
				labeltext = "MISSES";
			end
			self:settext( labeltext );
			self:visible(true);
			param.LabelZoom = scale( iCombo, 0, NumberMaxZoomAt, LabelMinZoom, LabelMaxZoom );
			param.LabelZoom = clamp( param.LabelZoom, LabelMinZoom, LabelMaxZoom );
 			self:stoptweening(); 
			self:zoomy(0);
			self:linear(0.05);
			self:zoomy(param.LabelZoom);
			self:zoomx(param.LabelZoom*1.2);
		end;
	};
	
	InitCommand = function(self)
		c = self:GetChildren();
		c.Number:visible(false);
		c.Label:visible(false);
	end;
	TwentyFiveMilestoneCommand=function(self,parent)
		(cmd(zoom,1.4;decelerate,0.4;zoom,1))(self);
	end;
	ToastyAchievedMessageCommand=function(self,params)
		if params.PlayerNumber == player then
--			(cmd(thump,2;effectclock,'beat'))(self);
		end;
	end;

};

return t;
